'===============================================================================================
'
'       CTG-1xx/2xx V[Y̐Tv\tg
'       [ CTG_SampleSoft Version 1.3 ]
'
'       AvP[ṼCʃtH[    [Form1.vb]
'
'       J
'           EMicrosoft Visual Basic 2008
'           E.NET Framework version 2.0
'
'       ӎ
'           EʐM͊ei̕WݒiLĵݑΉ
'             9600bpsA8bitAEvenParityA1StopBitABCC 1oCg
'             wb_[FSTX(02h)Atb^[FETX(03h)AZp[^FUS(1Fh)
'
'       GRAPHTEC Corporation      2014/03/04
'
'===============================================================================================
'
'       ύX
'       Ver1.0.0.0      2008/06/03     o[W
'       Ver1.1.0.0      2008/11/10     1)modFunctionW[̒
'                                      2)SendData()֐txtMonitor.Invoke\bhĂяoʒuύX
'                                      3)ShowMonitor()֐̕\ύX
'       Ver1.2.0.0      2014/03/04     1)Visual Basic 2008p ɃvWFNgϊ
'                                      2)modFunctionW[̒
'       Ver1.3.0.0      2017/10/24     ЖύX
'
'===============================================================================================
'
'       ⑫
'       VAʐMSerialPortNXgpĂ܂BSerialPortNX̃Cxg(DataReceived
'       PinChanged)ł́AForm1̃CXbhƂ͕ʂ̃ZJ_XbhĂA
'       ZJ_Xbh烁CXbh̓eύXƃG[܂B
'       MCxgSerialPortNX̃CxgForm1̓eύXꍇ́A
'       Form1̃Rg[Invoke\bhŃfQ[g^̃vV[Wɏn܂B
'
'===============================================================================================

Public Class Form1

    '-------------------------------------------------------------------------------------
    '   fQ[g^̐錾
    '-------------------------------------------------------------------------------------
    Delegate Sub ShowEventDelegate(ByVal ev As String)             'MCxg̃f[^\p
    Delegate Sub ShowStatusDelegate(ByVal st As String)            'u̐ڑԂ̕\p
    Delegate Sub ShowMonitorDelegate(ByVal dir As String, ByVal str As String)   'Mf[^̃j^[\p

    '-------------------------------------------------------------------------------------
    '   Tv@FMCxg̃f[^\ifQ[g^̃vV[WƂĎgpj
    '   @FstrHeader Cxgwb_[̕
    '-------------------------------------------------------------------------------------
    Private Sub ShowEvent(ByVal strHeader As String)
        Try
            Select Case strHeader
                Case "CR"                                           '[hʂ̎MCxg
                    If txtTrack1.Enabled Then
                        If JIS2Model Then ReadData(0) = CheckSOSI(ReadData(0))
                        txtTrack1.Text = ReadData(0)
                        lblResultTrack1.Text = GetErrorInformation(ReadWriteResult(0))
                    End If
                    If txtTrack2.Enabled Then
                        txtTrack2.Text = ReadData(1)
                        lblResultTrack2.Text = GetErrorInformation(ReadWriteResult(1))
                    End If
                    If txtTrack3.Enabled Then
                        txtTrack3.Text = ReadData(2)
                        lblResultTrack3.Text = GetErrorInformation(ReadWriteResult(2))
                    End If
                    lblResponse.Text = "[hf[^:" & Header & CheckControlCode(Parameter, ".")
                    lblStatus.Text = "[h̊"
                Case "CW"                                           'Cgʂ̎MCxg
                    If txtTrack1.Enabled Then lblResultTrack1.Text = GetErrorInformation(ReadWriteResult(0))
                    If txtTrack2.Enabled Then lblResultTrack2.Text = GetErrorInformation(ReadWriteResult(1))
                    If txtTrack3.Enabled Then lblResultTrack3.Text = GetErrorInformation(ReadWriteResult(2))
                    lblResponse.Text = "Cgʉ:" & Header & CheckControlCode(Parameter, ".")
                    lblStatus.Text = "Cg̊"
                Case "DH"                                           'G[̎MCxg
                    lblResponse.Text = "G[Cxg:" & Header & Parameter
                    lblStatus.Text = GetDH_Information(Parameter)
            End Select

        Catch ex As Exception
            MessageBox.Show(ex.Message, "G[", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@Fu̐ڑԂ̕\ifQ[g^̃vV[WƂĎgpj
    '   @Fst ԕ\̕
    '-------------------------------------------------------------------------------------
    Private Sub ShowStatus(ByVal st As String)
        Try
            lblStatus.Text = st
        Catch ex As Exception
            MessageBox.Show(ex.Message, "G[", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FMf[^̃j^[\ifQ[g^̃vV[WƂĎgpj
    '   @Fdir M/M̕\A str M̃f[^
    '-------------------------------------------------------------------------------------
    Private Sub ShowMonitor(ByVal dir As String, ByVal str As String)
        Dim i As Integer
        Dim work As String
        Try
            If rbtASCII.Checked Then
                work = CheckControlCode(str, ".")
            Else
                work = ""
                For i = 0 To Len(str) - 1
                    work = work & "0x" & Hex(Asc(str(i))) & " "
                Next
            End If
            txtMonitor.SelectionStart = txtMonitor.Text.Length
            txtMonitor.SelectedText = dir & work & vbCrLf
        Catch ex As Exception
            MessageBox.Show(ex.Message, "G[", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FtH[[hSerialPortvpeB̏
    '-------------------------------------------------------------------------------------
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        SerialPort1.BaudRate = 9600
        SerialPort1.DataBits = 8
        SerialPort1.Parity = IO.Ports.Parity.Even
        SerialPort1.StopBits = IO.Ports.StopBits.One
        SerialPort1.Handshake = IO.Ports.Handshake.None
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@F@Ȉ
    '-------------------------------------------------------------------------------------
    Private Sub cmbSeries_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbSeries.SelectedIndexChanged
        Dim ISO As Boolean = False      'ISO^Cv:TrueAJIS2^Cv:False
        Dim RW As Boolean = False       '[_C^:TrueA[_:False

        Select Case cmbSeries.SelectedIndex
            Case 1
                ISO = True
            Case 2
                RW = True
            Case 3
                ISO = True
                RW = True
        End Select

        'gbN1̃Rg[\ݒ
        lblTrack1.Enabled = True
        lblResultTrack1.Enabled = True
        txtTrack1.Enabled = True
        btnTrack1Clear.Enabled = True

        'gbN2̃Rg[\ݒ
        lblTrack2.Enabled = ISO
        lblResultTrack2.Enabled = ISO
        txtTrack2.Enabled = ISO
        btnTrack2Clear.Enabled = ISO

        'gbN3̃Rg[\ݒ
        lblTrack3.Enabled = ISO
        lblResultTrack3.Enabled = ISO
        txtTrack3.Enabled = ISO
        btnTrack3Clear.Enabled = ISO

        'R}hsp{^̃Rg[\ݒ
        btnRead.Enabled = True
        btnWrite.Enabled = RW
        btnStatus.Enabled = True
        btnReset.Enabled = True

        JIS2Model = Not ISO         'JIS2^CṽtOݒ

    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FVA|[g̃I[v
    '-------------------------------------------------------------------------------------
    Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click
        Try
            SerialPort1.PortName = txtPort.Text
            If SerialPort1.IsOpen = True Then
                MessageBox.Show("ł" & SerialPort1.PortName & "͐ڑĂ܂B", "G[", MessageBoxButtons.OK, MessageBoxIcon.Error)
            End If
            SerialPort1.Open()
            SerialPort1.RtsEnable = True                'RTSONɐݒ肷(CTSĎ̏ꍇ)
            btnOpen.Enabled = False
            btnClose.Enabled = Not btnOpen.Enabled
        Catch ex As Exception
            MessageBox.Show(ex.Message, "G[", MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FVA|[g̃N[Y
    '-------------------------------------------------------------------------------------
    Private Sub btnClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnClose.Click
        If SerialPort1.IsOpen = True Then
            Call SerialPort1.Close()
            btnOpen.Enabled = True
            btnClose.Enabled = Not btnOpen.Enabled
        End If
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FgbNPf[^̃NA
    '-------------------------------------------------------------------------------------
    Private Sub btnTrack1Clear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTrack1Clear.Click
        txtTrack1.Clear()
        lblResultTrack1.Text = ""
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FgbNQf[^̃NA
    '-------------------------------------------------------------------------------------
    Private Sub btnTrack2Clear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTrack2Clear.Click
        txtTrack2.Clear()
        lblResultTrack2.Text = ""
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FgbNRf[^̃NA
    '-------------------------------------------------------------------------------------
    Private Sub btnTrack3Clear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTrack3Clear.Click
        txtTrack3.Clear()
        lblResultTrack3.Text = ""
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FMj^[̃NA
    '-------------------------------------------------------------------------------------
    Private Sub btnMonitorClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMonitorClear.Click
        txtMonitor.Clear()
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@F[hR}h̎s
    '-------------------------------------------------------------------------------------
    Private Sub btnRead_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRead.Click
        Dim Res As String
        Res = SendBlockData("CRC")
        Call CheckCommandResponse(Res)
        If Res = ACK Then                           'ACKM̊mF
            lblStatus.Text = "J[hǂݎ菀̊" & vbCrLf & "J[h𑀍i}jĂ"
        Else
            If lblStatus.Text <> "" Then
                lblStatus.Text = lblStatus.Text & vbCrLf & "J[hǂݎ菀̎s"
            Else
                lblStatus.Text = "J[hǂݎ菀̎s"
            End If
        End If
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FCgR}h̎s
    '-------------------------------------------------------------------------------------
    Private Sub btnWrite_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnWrite.Click
        Dim sParam As String = ""
        Dim Res As String = ""

        If JIS2Model Then
            sParam = txtTrack1.Text
            sParam = CheckKANA(sParam) 'Jiꍇ͕ϊSO^SI}
        Else
            sParam = txtTrack1.Text & US & txtTrack2.Text & US & txtTrack3.Text
        End If

        Res = SendBlockData("CWC" & sParam)                 'R}h"CWC"M
        Call CheckCommandResponse(Res)
        If Res = ACK Then                                  'ACKM̊mF
            lblStatus.Text = "J[hݏ̊" & vbCrLf & "J[h𑀍i}jĂ"
        Else
            If lblStatus.Text <> "" Then
                lblStatus.Text = lblStatus.Text & vbCrLf & "J[hݏ̎s"
            Else
                lblStatus.Text = "J[hݏ̎s"
            End If
        End If
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FXe[^XR}h̎s
    '-------------------------------------------------------------------------------------
    Private Sub btnStatus_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStatus.Click
        Dim Res As String
        Res = SendBlockData("PSC")
        Call CheckCommandResponse(Res)
        If Mid(Res, 2, 3) = "PSC" Then                       'Xe[^X̂Ƃ
            lblResponse.Text = "Xe[^X:" & Header & Parameter
            lblStatus.Text = GetStatus_Information(Parameter)
        Else
            lblStatus.Text = "Xe[^X̎擾s"
        End If
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FZbgR}h̎s
    '-------------------------------------------------------------------------------------
    Private Sub btnReset_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnReset.Click
        Dim Res As String
        Res = SendBlockData("PR")
        Call CheckCommandResponse(Res)
        If Res = ACK Then                           'ACKM̊mF
            lblStatus.Text = "Zbg̊"
        Else
            lblStatus.Text = "Zbg̎s"
        End If
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FR}hSTX,ETX,BCCǉđMAw莞ԎM҂s֐
    '   @FsData R}h̕
    '   ߂lFMf[^̕
    '-------------------------------------------------------------------------------------
    Public Function SendBlockData(ByVal sData As String) As String
        Dim Work As String = ""
        Dim Res As String = ""
        Dim i As Integer = 0
        Work = AddStxEtxBcc(sData)                          'STX,ETX,BCC̒ǉ
        Try
            For i = 1 To 3                                  'NAKM3܂ōđ
                ReceiveData = ""
                Call SendData(Work)
                Res = ReceiveWait(1000)                     'w莞ԓ̎M҂(1000ms)
                If (Res = "") Or (Res = DLE) Then Exit For
                If Res <> NAK Then Exit For
            Next
            Return Res

        Catch ex As Exception
            MessageBox.Show(ex.Message, "G[", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return Res
        End Try
    End Function

    '-------------------------------------------------------------------------------------
    '   Tv@Ff[^̑M
    '   @FsData f[^̕
    '-------------------------------------------------------------------------------------
    Public Sub SendData(ByVal sData As String)
        Dim Monitor As New ShowMonitorDelegate(AddressOf ShowMonitor)   'fQ[gNX̃CX^X𐶐
        ReceiveBuff = ""
        txtMonitor.Invoke(Monitor, "SD: ", sData)         'Invoke\bhőMf[^j^[\
        SerialPort1.DiscardOutBuffer()                    'Mobt@̃NA
        SerialPort1.Write(sData)
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FSerialPortNX̎MCxg
    '-------------------------------------------------------------------------------------
    Private Sub SerialPort1_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort1.DataReceived
        Dim Monitor As New ShowMonitorDelegate(AddressOf ShowMonitor)  'fQ[gNX̃CX^X𐶐
        Try
            tmrRecFinish.Enabled = False
            ReceiveBuff = ReceiveBuff & SerialPort1.ReadExisting        'Mf[^̎擾

            Select Case CheckReceiveData(ReceiveBuff)                   'M𔻒肵܂
                Case COMMAND_RES                                        'R}h̎M
                    txtMonitor.Invoke(Monitor, "RD: ", ReceiveBuff)     'Invoke\bhŎMf[^j^[\
                    ReceiveBuff = ""
                Case EVENT_RES                                          'Cxg̎M
                    txtMonitor.Invoke(Monitor, "RD: ", ReceiveBuff)     'Invoke\bhŎMf[^j^[\
                    ReceiveBuff = ""
                    Call SendData(ACK)                                  'ACKM
                    Call CheckEventResponse(ReceiveData)                'Cxgf[^̉
                Case BCC_ERROR                                          'Mf[^BCCG[
                    txtMonitor.Invoke(Monitor, "RD: ", ReceiveBuff)     'Invoke\bhŎMf[^j^[\
                    Call SendData(NAK)                                  'NAKM
                Case NO_FINISH_RES                                      'M
                    tmrRecFinish.Interval = 200                         'M莞Ԃ̐ݒ(200ms)F{[[gɂēK؂ȎԂɕύX܂B
                    '                                                    1oCgMĂ玟1oCgM܂ł̃^CAEg
                    tmrRecFinish.Enabled = True                         'M^C}[̎n
            End Select

        Catch ex As Exception
            ReceiveBuff = ex.Message
        End Try
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FCTSM̕ωԂ\܂
    '-------------------------------------------------------------------------------------
    Private Sub SerialPort1_PinChanged(ByVal sender As System.Object, ByVal e As System.IO.Ports.SerialPinChangedEventArgs) Handles SerialPort1.PinChanged
        Dim sts As New ShowStatusDelegate(AddressOf ShowStatus)    'fQ[gNX̃CX^X𐶐
        If e.EventType = IO.Ports.SerialPinChange.CtsChanged Then
            If SerialPort1.CtsHolding Then
                lblStatus.Invoke(sts, "CTSONɂȂ܂")      'Invoke\bhCTS̏Ԃ\
            Else
                lblStatus.Invoke(sts, "CTSOFFɂȂ܂")     'Invoke\bhCTS̏Ԃ\
            End If
        End If
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FM^C}[̃CxgŎM𔻒肷
    '-------------------------------------------------------------------------------------
    Private Sub tmrRecFinish_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrRecFinish.Tick
        Dim Monitor As New ShowMonitorDelegate(AddressOf ShowMonitor)  'fQ[gNX̃CX^X𐶐
        tmrRecFinish.Enabled = False

        ReceiveBuff = ReceiveBuff & SerialPort1.ReadExisting            'Mf[^̎擾
        txtMonitor.Invoke(Monitor, "RD: ", ReceiveBuff)                 'Invoke\bhŎMf[^j^[\

        Select Case CheckReceiveData(ReceiveBuff)
            Case EVENT_RES                                              'Cxg̎M
                Call SendData(ACK)                                      'ACKM
                Call CheckEventResponse(ReceiveData)                    'Cxgf[^̉
            Case BCC_ERROR                                              'Mf[^BCCG[
                Call SendData(NAK)                                      'NAKM
        End Select

        ReceiveBuff = ""
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@Fw莞Ԃ܂ŎM҂֐
    '   @FintWaitTime (PʂF~bj
    '   ߂lFM
    '-------------------------------------------------------------------------------------
    Public Function ReceiveWait(ByVal intWaitTime As Integer) As String
        ReceiveData = ""                                    'Mf[^̏
        SerialPort1.DiscardInBuffer()                       'Mobt@̃NA
        tmrTimeOut.Interval = intWaitTime
        tmrTimeOut.Enabled = True                           'M^CAEg^C}[̎n
        Application.DoEvents()                              '̃vZXɐn܂B
        Do While tmrTimeOut.Enabled                         'M^CAEg^C}[̏I҂
            If ReceiveData <> "" Then Exit Do
            Application.DoEvents()                          '̃vZXɐn܂B
        Loop
        Return ReceiveData
    End Function

    '-------------------------------------------------------------------------------------
    '   Tv@FM^CAEg^C}[̃Cxg
    '-------------------------------------------------------------------------------------
    Private Sub tmrTimeOut_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrTimeOut.Tick
        tmrTimeOut.Enabled = False
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FR}hmF֐
    '   @FResData f[^
    '-------------------------------------------------------------------------------------
    Private Sub CheckCommandResponse(ByVal ResData As String)
        If ResData = "" Then
            lblResponse.Text = "Ȃ"
        ElseIf Len(ResData) = 1 Then                        'R[h̊mF
            Select Case ResData
                Case ACK
                    lblResponse.Text = "ACKM"
                Case NAK
                    lblResponse.Text = "NAKM"
                Case DLE
                    lblResponse.Text = "DLEM"
            End Select
        ElseIf Len(ResData) > 4 Then                        '̑̉̊mF
            Select Case Mid(ResData, 2, 2)
                Case "NG"                                   'NG
                    lblResponse.Text = "NG:" & Header & Parameter
                    lblStatus.Text = GetNG_Information(Parameter)
            End Select
        End If
    End Sub

    '-------------------------------------------------------------------------------------
    '   Tv@FCxgmF֐
    '   @FResData Cxgf[^
    '-------------------------------------------------------------------------------------
    Private Sub CheckEventResponse(ByVal ResData As String)
        Dim SEvent As New ShowEventDelegate(AddressOf ShowEvent)    'fQ[gNX̃CX^X𐶐
        If Len(ResData) < 5 Then Exit Sub
        Select Case Mid(ResData, 2, 2)
            Case "CR"                                           '[hCxg
                Call AnalyzeReadData(Parameter)
                txtTrack1.Invoke(SEvent, "CR")                  'Invoke\bhŎMCxgj^[\
            Case "CW"                                           'CgCxg
                Call AnalyzeWriteResult(Parameter)
                txtTrack1.Invoke(SEvent, "CW")                  'Invoke\bhŎMCxgj^[\
            Case "DH"                                           'G[Cxg
                txtTrack1.Invoke(SEvent, "DH")                  'Invoke\bhŎMCxgj^[\
        End Select
    End Sub

End Class
